#include <math.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include <tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>

#include <myUart.h>

//Initialize the UART functionality in port A
void Init_UARTA(void)
{

    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    UART0_CC_R = 0x05;
    UART0_IBRD_R = 8;
    UART0_FBRD_R = 44;
    UART0_LCRH_R |= UART_LCRH_WLEN_8;

    UART0_CTL_R |= UART_CTL_UARTEN;
    UART0_CTL_R |= UART_CTL_TXE | UART_CTL_RXE;

    GPIO_PORTA_DEN_R |= (1 << 0) | (1 << 1);

    GPIO_PORTA_AFSEL_R = (1 << 0) | (1 << 1);

    GPIO_PORTA_PCTL_R = (1 << 0) | (1 << 4);

    GPIO_PORTA_AMSEL_R = 0;

    UART0_IM_R |= UART_IM_RXIM;
    NVIC_PRI1_R = (NVIC_PRI1_R & 0xFFFF1FFF) | 0x00008000;
    NVIC_EN0_R |= (1 << 5);
    UART0_ICR_R |= UART_ICR_RXIC;
}

//Writes the charecter c on the terminal
void putChar(char c)
{
    UARTCharPut(UART0_BASE, c);
}

// Writes string s on the terminal
void putString(char *s)
{

    while (*s != '\0')
    {
        putChar(*s);
        s++;
    }
    return;
}

//For printing any integer on the terminal directlly
void putInt(int c)
{
    char buffer[20];
    itoa(c, buffer, 10);   // here 10 means decimal
    putString(buffer);
}

// For sending +ve floating point number through UART
void putFloatPos(float n, int r)
{
    int int_part = (int) n;
    float frac_part = (n - int_part);
    //float_part_temp = float_part;
    putInt(int_part);
    putChar('.');
    short i, num;
    int base = 10;
    for (i = 0; i < r; i++)
    {
        num = ((int) (frac_part * base)) % 10;
        putChar(num + '0');
        base = base * 10;
    }
}

// for sending any floating point number through UART
//r is the total number of digit after decimal
void putFloat(float n, int r)
{
    if (n > 0)
    {
        putFloatPos(n, r);
    }
    else
    {
        putChar('-');
        putFloatPos(-1 * n, r);
    }
    putChar('\r');
    putChar('\n');
}

void UART0_Handler(void)
{
    unsigned char val = 0;
    UART0_ICR_R |= (UART_ICR_RXIC); // Clear receive interrupt
    val = UART0_DR_R; // get the received data byte

    putChar(val); // send data that is received to display on screen
    // do the part of getString function which was done in the case of polling
    *temp_str = val;
    temp_str++;
    //printInt(val);
    if ((val == '\n') || (val == '\r'))
    { // means the user has pressed the enter key
        temp_str = temp_str - 1; //delete the last char
        *temp_str = '\0'; // and replace it with a null charecter
        temp_str = input_str; // update the value to the old value
        //now the string is ready for processString
        putChar('\n');
        putChar('\r');
        //processString call
        doUARTOperation = 1;
    }
    else if (val == '\b')
    {        // just ignore the backspce and delet the previous charecter
        temp_str = temp_str - 2;
    }

}

/*
 * 1F17, 2A1.5
 * */
void processString(char *temp)
{
    doUARTOperation = 0;
    sanitizeStringNew(temp);

    short channelNumber = (*temp) - '0';
    char opt = *(temp + 1);
    if (channelNumber == 1)
    {
        // do all operation in channel 1
        if (opt == 'F')
        { //update freq
            char *updatedFreqStr = temp + 2;

            freq = atof(updatedFreqStr);
            if (freq >= 10)
            {
                freq = 10;
            }
            else if (freq < 0)
            {
                freq = 0;
            }

        }
        else if (opt == 'A')
        { //update amp
            char *updatedAmpStr = temp + 2;
            amp = atof(updatedAmpStr);

            if (amp >= 3)
            {
                amp = 3;
            }
            else if (amp < 0)
            {
                amp = 0;
            }
        }
        else
        {
            putString("Entered command is not correct");
        }
    }
    else if (channelNumber == 2)
    {
        // do all operation in channel 2
        if (opt == 'F')
        { //update freqCh2
            char *updatedFreqCh2Str = temp + 2;
            freqCh2 = atof(updatedFreqCh2Str);
            if (freqCh2 >= 10)
            {
                freqCh2 = 10;
            }
            else if (freqCh2 < 0)
            {
                freqCh2 = 0;
            }
        }
        else if (opt == 'A')
        { //update ampCh2
            char *updatedAmpCh2Str = temp + 2;
            ampCh2 = atof(updatedAmpCh2Str);
            if (ampCh2 >= 3)
            {
                ampCh2 = 3;
            }
            else if (ampCh2 < 0)
            {
                ampCh2 = 0;
            }
        }
        else
        {
            putString("Entered command is not correct");
        }
    }
    else
    {
        putString("Entered command is not correct");
    }
    putChar('\n');
}

//mean the string output does not have any space in it and no backspace charecter as well and the separating charecter is * for parsing the string
char* sanitizeStringNew(char *str)
{
    int i = 0, j = 0;

    char *old_str = (char*) malloc(sizeof(char) * 50);
    for (i = 0; str[i] != '\0'; i++)
    {
        old_str[i] = str[i];
    }

    old_str[i] = '\0';

    for (i = 0; old_str[i] != '\0'; i++)
    {
        if (old_str[i] != ' ')
        { // normal copy
            str[j++] = old_str[i];
        }
    }

    str[j] = '\0';

    strupr(str); // to lower case

    putString(str);
    return str;
}
